/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.applets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CFSlider
extends JPanel
implements ChangeListener {
    private boolean m_bInited = false;
    private final JPanel m_panelUpper;
    private final JLabel m_labelPrefix;
    private final JLabel m_labelValue;
    private final JLabel m_labelSuffix;
    private final JSlider m_slider;
    private final boolean m_bShowLabel;
    private final String EMPTY_STRING_HACK = "   ";

    CFSlider(String string, String string2, boolean bl) {
        this.setLayout(new BorderLayout());
        this.setBorder(new BevelBorder(1, Color.lightGray, Color.gray));
        this.m_labelPrefix = new JLabel(string);
        this.m_labelValue = new JLabel();
        this.m_labelSuffix = new JLabel(string2);
        this.m_panelUpper = new JPanel();
        this.m_panelUpper.setLayout(new FlowLayout(0, 0, 0));
        this.m_panelUpper.add(this.m_labelPrefix);
        this.m_panelUpper.add(this.m_labelValue);
        this.m_panelUpper.add(this.m_labelSuffix);
        this.add((Component)this.m_panelUpper, "North");
        this.m_slider = new JSlider();
        this.add((Component)this.m_slider, "Center");
        if (!bl) {
            this.m_slider.addChangeListener(this);
        }
        this.m_bInited = true;
        this.m_bShowLabel = string != null || string2 != null;
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        if (!this.m_bInited) {
            return;
        }
        if (!this.m_bShowLabel) {
            this.m_panelUpper.setPreferredSize(new Dimension(dimension.width, 0));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        String string = this.m_bShowLabel ? String.valueOf(jSlider.getValue()) : "   ";
        this.m_labelValue.setText(string);
    }

    public void setValue(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setValue(n);
        String string = this.m_bShowLabel ? String.valueOf(n) : "   ";
        this.m_labelValue.setText(string);
    }

    public int getValue() {
        if (!this.m_bInited) {
            return 0;
        }
        return this.m_slider.getValue();
    }

    public void setMinimum(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setMinimum(n);
    }

    public void setMaximum(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setMaximum(n);
    }

    public void setPaintLabels(boolean bl) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setPaintLabels(bl);
    }

    public void setPaintTicks(boolean bl) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setPaintTicks(bl);
    }

    public void setMajorTickSpacing(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setMajorTickSpacing(n);
    }

    public void setMinorTickSpacing(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setMinorTickSpacing(n);
    }

    public void setSnapToTicks(boolean bl) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setSnapToTicks(bl);
    }

    public void setLabelTable(Hashtable hashtable) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setLabelTable(hashtable);
    }

    public void setOrientation(int n) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.setOrientation(n);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.m_bInited) {
            return;
        }
        this.m_slider.addChangeListener(changeListener);
    }

    public int getMinimum() {
        if (!this.m_bInited) {
            return 0;
        }
        return this.m_slider.getMinimum();
    }

    public int getMaximum() {
        if (!this.m_bInited) {
            return 0;
        }
        return this.m_slider.getMaximum();
    }

    public int getMajorTickSpacing() {
        if (!this.m_bInited) {
            return 0;
        }
        return this.m_slider.getMajorTickSpacing();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (!this.m_bInited) {
            return;
        }
        this.m_panelUpper.setForeground(color);
        this.m_labelPrefix.setForeground(color);
        this.m_labelValue.setForeground(color);
        this.m_labelSuffix.setForeground(color);
        this.m_slider.setForeground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (!this.m_bInited) {
            return;
        }
        this.m_panelUpper.setBackground(color);
        this.m_labelPrefix.setBackground(color);
        this.m_labelValue.setBackground(color);
        this.m_labelSuffix.setBackground(color);
        this.m_slider.setBackground(color);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (!this.m_bInited) {
            return;
        }
        this.m_labelPrefix.setFont(font);
        this.m_labelValue.setFont(font);
        this.m_labelSuffix.setFont(font);
    }

    public Font getFont() {
        if (!this.m_bInited) {
            return super.getFont();
        }
        return this.m_labelPrefix.getFont();
    }
}

